*REPORT SETUP AND BASE REPORT of CGE2====================================

*SET AND PARAMETERS FOR REPORTS++++++++

*$ontext

SET
 SIM  simulations
     /BASE  base simulation
      PROD  increase AGR-A productivity/




PARAMETERS
*++
 AGRPRODSIM(SIM)   agriculture productivity for sim'on sim (experiment parameter)

 QFSREP(F,SIM)    supply of factor f for simulation sim (value used)
 PREP(C,SIM)      demander price for commodity c
 PAREP(A,SIM)     price of activity a
 PVAREP(A,SIM)    value-added price for activity a
 QREP(C,SIM)      output level for commodity c
 QAREP(A,SIM)     level of activity a
 QFREP(F,A,SIM)   demand for factor f from activity a
 QHREP(C,H,SIM)   consumption of commodity c by household h
 QINTREP(C,A,SIM) qnty of commodity c as intermed. input for activity a
 WFREP(F,SIM)     price of factor f
 YFREP(H,F,SIM)   income of household h from factor f
 YHREP(H,SIM)     income of household h
 ;


 AGRPRODSIM('BASE')  =  ica('NAGR-C','AGR-A');
*Complete!!
 AGRPRODSIM('PROD')  =                              ;


DISPLAY AGRPRODSIM;



LOOP(SIM,
*++
 ica('NAGR-C','AGR-A') = AGRPRODSIM(SIM);


SOLVE CGE2 USING MCP;

 QFSREP(F,SIM)    = qfs(F);
 PREP(C,SIM)      = P.L(C);
 PAREP(A,SIM)     = PA.L(A);
 PVAREP(A,SIM)    = PVA.L(A);
 QREP(C,SIM)      = Q.L(C);
 QAREP(A,SIM)     = QA.L(A);
 QFREP(F,A,SIM)   = QF.L(F,A);
 QHREP(C,H,SIM)   = QH.L(C,H);
 QINTREP(C,A,SIM) = QINT.L(C,A);
 WFREP(F,SIM)     = WF.L(F);
 YFREP(H,F,SIM)   = YF.L(H,F);
 YHREP(H,SIM)     = YH.L(H);

 );

OPTION QFREP:3:1:1, QHREP:3:1:1, YFREP:3:1:1;

DISPLAY
 QFSREP, PREP, PAREP, PVAREP, QREP, QAREP, QFREP, QHREP, QINTREP,
 WFREP, YFREP, YHREP ;

*Parameters reporting %-age change from BASE for model variables and
*for selected other data.
PARAMETERS

 QFSREPP(F,SIM)    supply of factor f for simulation sim (value used)
 PREPP(C,SIM)      demander price for commodity c
 PAREPP(A,SIM)     price of activity a
 PVAREPP(A,SIM)    value-added price for activity a
 QREPP(C,SIM)      output level for commodity c
 QAREPP(A,SIM)     level of activity a
 QFREPP(F,A,SIM)   demand for factor f from activity a
 QHREPP(C,H,SIM)   consumption of commodity c by household h
 QINTREPP(C,A,SIM) qnty of commodity c as intermed. input for activity a
 WFREPP(F,SIM)     price of factor f
 YFREPP(H,F,SIM)   income of household h from factor f
 YHREPP(H,SIM)     income of household h
 ;

 QFSREPP(F,SIM)     = 100*(QFSREP(F,SIM)   /       QFSREP(F,'BASE')    - 1);
 PREPP(C,SIM)       = 100*(PREP(C,SIM)     /       PREP(C,'BASE')      - 1);
 PAREPP(A,SIM)      = 100*(PAREP(A,SIM)    /       PAREP(A,'BASE')     - 1);
 PVAREPP(A,SIM)     = 100*(PVAREP(A,SIM)   /       PVAREP(A,'BASE')    - 1);
 QREPP(C,SIM)       = 100*(QREP(C,SIM)     /       QREP(C,'BASE')      - 1);
 QAREPP(A,SIM)      = 100*(QAREP(A,SIM)    /       QAREP(A,'BASE')     - 1);
 QFREPP(F,A,SIM)    = 100*(QFREP(F,A,SIM)  /       QFREP(F,A,'BASE')   - 1);
 QHREPP(C,H,SIM)    = 100*(QHREP(C,H,SIM)  /       QHREP(C,H,'BASE')   - 1);
 QINTREPP(C,A,SIM)  = 100*(QINTREP(C,A,SIM)/       QINTREP(C,A,'BASE') - 1);
 WFREPP(F,SIM)      = 100*(WFREP(F,SIM)    /       WFREP(F,'BASE')     - 1);
 YFREPP(H,F,SIM)    = 100*(YFREP(H,F,SIM)  /       YFREP(H,F,'BASE')   - 1);
 YHREPP(H,SIM)      = 100*(YHREP(H,SIM)    /       YHREP(H,'BASE')     - 1);

 OPTION QFREPP:3:1:1, QHREPP:3:1:1, YFREPP:3:1:1;


DISPLAY
 QFSREPP, PREPP, PAREPP, PVAREPP, QREPP, QAREPP, QFREPP, QHREPP, QINTREPP,
 WFREPP, YFREPP, YHREPP ;


*$offtext